@include('admin.header') 

<style >label{
    font-weight: 700;
}</style>
<div class="container bg-white p-3">
    <h1>Edit Knitting Type</h1>
    <form action="{{ route('admin.knitting_types.update', $knittingType->id) }}" method="POST">
        @csrf
        @method("PUT")
        <div class="mb-3">
            <label for="name" class="form-label">Name</label>
            <input type="text" class="form-control" id="name" name="name" value="{{ $knittingType->name }}" required>
        </div>
        <div class="mb-3">
            <label for="charge" class="form-label">Charge (USD/kg)</label>
            <input type="number" step="0.01" class="form-control" id="charge" name="charge" value="{{ $knittingType->charge }}" required>
        </div>
        <div class="mb-3">
            <label for="description" class="form-label">Description</label>
            <textarea class="form-control" id="description" name="description">{{ $knittingType->description }}</textarea>
        </div>
        <div class="mb-3 form-check">
            <input type="checkbox" class="form-check-input" id="is_active" name="is_active" value="1" {{ $knittingType->is_active ? "checked" : "" }}>
            <label class="form-check-label" for="is_active">Active</label>
        </div>
        <button type="submit" class="btn btn-primary">Update</button>
        <a href="{{ route('admin.knitting_types.index') }}" class="btn btn-secondary">Cancel</a>
    </form>
</div>
@include('admin.footer') 



