@include('admin.header') 

<div class="container">
    <div class="row mb-3">
        <div class="col-md-6">
            <h1>Commercial Rates</h1>
        </div>
        <div class="col-md-6 text-right">
            <a href="{{ route('admin.commercial_rates.create') }}" class="btn btn-primary mb-3">
                <i class="fas fa-plus"></i> Add New Commercial Rate
            </a>
        </div>
    </div>

    @if (session("success"))
        <div class="alert alert-success">{{ session("success") }}</div>
    @endif

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead class="text-white bg-dark">
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Percentage (%)</th>
                            <th>Active</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($commercialRates as $commercialRate)
                            <tr>
                                <td>{{ $commercialRate->id }}</td>
                                <td>{{ $commercialRate->name }}</td>
                                <td>{{ $commercialRate->percentage }}</td>
                                <td>{{ $commercialRate->is_active ? "Yes" : "No" }}</td>
                                <td>
                                  
                                    <a href="{{ route('admin.commercial_rates.edit', $commercialRate->id) }}" class="btn btn-primary btn-sm">
                                        <i class="fas fa-edit"></i> Update
                                    </a>
                                    <form action="{{ route('admin.commercial_rates.destroy', $commercialRate->id) }}" method="POST" style="display:inline-block;">
                                        @csrf
                                        @method("DELETE")
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">
                                            <i class="fas fa-trash"></i> Remove
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@include('admin.footer') 
