@include('admin.header') 

<style >label{
    font-weight: 700;
}</style>
<div class="container bg-white p-3">
    <h1>Edit Commercial Rate</h1>
    <form action="{{ route('admin.commercial_rates.update', $commercialRate->id) }}" method="POST">
        @csrf
        @method("PUT")
        <div class="mb-3">
            <label for="name" class="form-label">Name</label>
            <input type="text" class="form-control" id="name" name="name" value="{{ $commercialRate->name }}" required>
        </div>
        <div class="mb-3">
            <label for="percentage" class="form-label">Percentage (%)</label>
            <input type="number" step="0.01" class="form-control" id="percentage" name="percentage" value="{{ $commercialRate->percentage }}" required>
        </div>
        <div class="mb-3">
            <label for="description" class="form-label">Description</label>
            <textarea class="form-control" id="description" name="description">{{ $commercialRate->description }}</textarea>
        </div>
        <div class="mb-3 form-check">
            <input type="checkbox" class="form-check-input" id="is_active" name="is_active" value="1" {{ $commercialRate->is_active ? "checked" : "" }}>
            <label class="form-check-label" for="is_active">Active</label>
        </div>
        <button type="submit" class="btn btn-primary">Update</button>
        <a href="{{ route('admin.commercial_rates.index') }}" class="btn btn-secondary">Cancel</a>
    </form>
</div>
@include('admin.footer') 


